<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Tag;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TagController extends Controller
{
    public function index()
    {
        $tags = Tag::where('uid', Auth::id())->orderBy('created', 'desc')->paginate(25);
        return view('dashboard.contacts.tags', compact('tags'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:100',
            'color' => 'required|string|max:7',
        ]);
        Tag::create([
            'uid' => Auth::id(),
            'name' => $request->name,
            'color' => $request->color,
        ]);
        return back()->with('success', __('messages.tag_created'));
    }

    public function update(Request $request, Tag $tag)
    {
        $request->validate([
            'name' => 'required|string|max:100',
            'color' => 'required|string|max:7',
        ]);
        $tag->update($request->only(['name', 'color']));
        return back()->with('success', __('messages.tag_updated'));
    }

    public function destroy(Tag $tag)
    {
        $tag->delete();
        return back()->with('success', __('messages.tag_deleted'));
    }
}
