<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Source;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SourceController extends Controller
{
    public function index()
    {
        $sources = Source::where('uid', Auth::id())->orderBy('create_date', 'desc')->paginate(25);
        return view('dashboard.contacts.sources', compact('sources'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);
        Source::create([
            'uid' => Auth::id(),
            'name' => $request->name,
            'description' => $request->description,
        ]);
        return back()->with('success', __('messages.source_created'));
    }

    public function update(Request $request, Source $source)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);
        $source->update($request->only(['name', 'description']));
        return back()->with('success', __('messages.source_updated'));
    }

    public function destroy(Source $source)
    {
        $source->delete();
        return back()->with('success', __('messages.source_deleted'));
    }
}
