<?php

namespace App\Http\Controllers\Dashboard\Sms;

use App\Http\Controllers\Controller;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TransactionController extends Controller
{
    public function index(Request $request)
    {
        $transactions = Transaction::where('uid', Auth::id())
            ->with('package')
            ->orderBy('create_date', 'desc')
            ->paginate(25);
            
        return view('dashboard.sms.transactions', compact('transactions'));
    }
}
