<?php

namespace App\Http\Controllers\Dashboard\Sms;

use App\Http\Controllers\Controller;
use App\Models\Campaign;
use App\Models\Device;
use App\Models\Group;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CampaignController extends Controller
{
    public function index(Request $request)
    {
        $campaigns = Campaign::where('uid', Auth::id())
            ->orderBy('create_date', 'desc')
            ->paginate(25);
            
        return view('dashboard.sms.campaigns', compact('campaigns'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'did' => 'required|string',
        ]);

        Campaign::create([
            'uid' => Auth::id(),
            'did' => $request->did,
            'gateway' => $request->gateway ?? 1,
            'mode' => $request->mode ?? 1,
            'status' => 1,
            'name' => $request->name,
            'contacts' => 0,
        ]);

        return back()->with('success', __('messages.campaign_created'));
    }

    public function destroy(Campaign $campaign)
    {
        $campaign->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
