<?php

namespace App\Http\Controllers\Dashboard\Hosts;

use App\Http\Controllers\Controller;
use App\Models\Ussd;
use App\Models\Device;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UssdController extends Controller
{
    public function index(Request $request)
    {
        $ussd = Ussd::where('uid', Auth::id())
            ->orderBy('create_date', 'desc')
            ->paginate(25);
            
        $devices = Device::where('uid', Auth::id())->get();
        
        return view('dashboard.hosts.ussd', compact('ussd', 'devices'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'did' => 'required|string',
            'code' => 'required|string|max:100',
        ]);

        Ussd::create([
            'uid' => Auth::id(),
            'did' => $request->did,
            'sim' => $request->sim ?? 0,
            'code' => $request->code,
            'response' => '',
            'status' => 1, // Pending
        ]);

        return back()->with('success', __('messages.ussd_sent'));
    }

    public function destroy(Ussd $ussd)
    {
        $ussd->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
