<?php

namespace App\Http\Controllers\Dashboard\Hosts;

use App\Http\Controllers\Controller;
use App\Models\Device;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class DeviceController extends Controller
{
    public function index(Request $request)
    {
        $devices = Device::where('uid', Auth::id())
            ->orderBy('create_date', 'desc')
            ->paginate(25);
            
        return view('dashboard.hosts.android', compact('devices'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
        ]);

        Device::create([
            'uid' => Auth::id(),
            'did' => Str::uuid(),
            'name' => $request->name,
            'manufacturer' => $request->manufacturer,
            'version' => $request->version ?? 0,
            'global_device' => $request->global_device ?? 0,
            'global_priority_device' => $request->global_priority_device ?? 0,
            'shared' => $request->shared ?? 0,
            'limit_status' => $request->limit_status ?? 0,
            'limit_interval' => $request->limit_interval ?? 0,
            'limit_value' => $request->limit_value ?? 0,
            'random_send' => $request->random_send ?? 0,
            'random_min' => $request->random_min ?? 0,
            'random_max' => $request->random_max ?? 0,
        ]);

        return back()->with('success', __('messages.device_created'));
    }

    public function update(Request $request, Device $device)
    {
        $request->validate(['name' => 'required|string|max:255']);
        $device->update($request->all());
        return back()->with('success', __('messages.device_updated'));
    }

    public function destroy(Device $device)
    {
        $device->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
