<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Group;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class GroupController extends Controller
{
    public function index()
    {
        $groups = Group::where('uid', Auth::id())
            ->orderBy('create_date', 'desc')
            ->paginate(25);
        return view('dashboard.contacts.groups', compact('groups'));
    }

    public function store(Request $request)
    {
        $request->validate(['name' => 'required|string|max:255']);
        Group::create([
            'uid' => Auth::id(),
            'name' => $request->name,
        ]);
        return back()->with('success', __('messages.group_created'));
    }

    public function update(Request $request, Group $group)
    {
        $this->authorize('update', $group);
        $request->validate(['name' => 'required|string|max:255']);
        $group->update(['name' => $request->name]);
        return back()->with('success', __('messages.group_updated'));
    }

    public function destroy(Group $group)
    {
        $this->authorize('delete', $group);
        $group->delete();
        return back()->with('success', __('messages.group_deleted'));
    }
}
