<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ApiKey;
use Illuminate\Support\Str;

class ApiKeyController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $keys = ApiKey::where('uid', auth()->id())->get();
        return view('dashboard.tools.keys', compact('keys'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        $key = Str::random(32);

        ApiKey::create([
            'uid' => auth()->id(),
            'name' => $request->name,
            'key' => $key,
            'permissions' => is_array($request->permissions) ? implode(',', $request->permissions) : 'send_sms,send_whatsapp',
            'status' => 1
        ]);

        return redirect()->route('dashboard.tools.keys')
            ->with('success', __('api_key_created'))
            ->with('new_key', $key);
    }

    public function destroy($id)
    {
        ApiKey::where('uid', auth()->id())->findOrFail($id)->delete();
        return redirect()->route('dashboard.tools.keys')->with('success', __('api_key_deleted'));
    }

    public function regenerate($id)
    {
        $apiKey = ApiKey::where('uid', auth()->id())->findOrFail($id);
        $newKey = Str::random(32);
        $apiKey->update(['key' => $newKey]);

        return redirect()->route('dashboard.tools.keys')
            ->with('success', __('api_key_regenerated'))
            ->with('new_key', $newKey);
    }
}
