<?php

namespace App\Http\Controllers\Dashboard\Ai;

use App\Http\Controllers\Controller;
use App\Models\AiKey;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AiKeyController extends Controller
{
    public function index(Request $request)
    {
        $keys = AiKey::where('uid', Auth::id())
            ->orderBy('create_date', 'desc')
            ->paginate(25);
            
        return view('dashboard.ai.keys', compact('keys'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'apikey' => 'required|string',
            'provider' => 'required|string|in:openai,anthropic,google',
        ]);

        AiKey::create([
            'uid' => Auth::id(),
            'name' => $request->name,
            'prompt' => $request->prompt,
            'post_prompt' => $request->post_prompt,
            'model' => $request->model ?? 'gpt-4',
            'history' => $request->history ?? 10,
            'max_tokens' => $request->max_tokens ?? 1024,
            'vision' => $request->vision ?? 0,
            'transcription' => $request->transcription ?? 0,
            'apikey' => $request->apikey,
            'provider' => $request->provider,
        ]);

        return back()->with('success', __('messages.ai_key_created'));
    }

    public function update(Request $request, AiKey $aiKey)
    {
        $request->validate([
            'name' => 'required|string|max:255',
        ]);
        
        $data = $request->only(['name', 'prompt', 'post_prompt', 'model', 'history', 'max_tokens', 'vision', 'transcription', 'provider']);
        
        if ($request->apikey) {
            $data['apikey'] = $request->apikey;
        }
        
        $aiKey->update($data);
        return back()->with('success', __('messages.ai_key_updated'));
    }

    public function destroy(AiKey $aiKey)
    {
        $aiKey->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
