<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Voucher;
use App\Models\Package;

class VoucherController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'admin']);
    }

    public function index()
    {
        $vouchers = Voucher::with('package')->orderBy('created_at', 'desc')->get();
        $packages = Package::where('status', 1)->get();
        return view('admin.vouchers.index', compact('vouchers', 'packages'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'code' => 'required|string|unique:vouchers',
            'type' => 'required|in:percentage,fixed',
            'discount' => 'required|numeric|min:0'
        ]);

        Voucher::create([
            'code' => strtoupper($request->code),
            'pid' => $request->pid,
            'type' => $request->type,
            'discount' => $request->discount,
            'max_uses' => $request->max_uses,
            'used' => 0,
            'expires_at' => $request->expires_at,
            'status' => $request->has('status') ? 1 : 0
        ]);

        return redirect()->route('admin.vouchers.index')->with('success', __('voucher_created'));
    }

    public function update(Request $request, $id)
    {
        $voucher = Voucher::findOrFail($id);

        $voucher->update([
            'code' => strtoupper($request->code),
            'pid' => $request->pid,
            'type' => $request->type,
            'discount' => $request->discount,
            'max_uses' => $request->max_uses,
            'expires_at' => $request->expires_at,
            'status' => $request->has('status') ? 1 : 0
        ]);

        return redirect()->route('admin.vouchers.index')->with('success', __('voucher_updated'));
    }

    public function destroy($id)
    {
        Voucher::findOrFail($id)->delete();
        return redirect()->route('admin.vouchers.index')->with('success', __('voucher_deleted'));
    }
}
