<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Subscription;
use App\Models\Package;
use App\Models\User;

class SubscriptionController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'admin']);
    }

    public function index()
    {
        $subscriptions = Subscription::with(['user', 'package'])
            ->orderBy('created_at', 'desc')
            ->paginate(20);
        $packages = Package::where('status', 1)->get();
        $users = User::all();

        return view('admin.subscriptions.index', compact('subscriptions', 'packages', 'users'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'uid' => 'required|exists:users,id',
            'pid' => 'required|exists:packages,id',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after:start_date'
        ]);

        Subscription::create([
            'uid' => $request->uid,
            'pid' => $request->pid,
            'start_date' => $request->start_date,
            'end_date' => $request->end_date,
            'status' => 'active'
        ]);

        return redirect()->route('admin.subscriptions.index')->with('success', __('subscription_created'));
    }

    public function update(Request $request, $id)
    {
        $subscription = Subscription::findOrFail($id);

        $subscription->update([
            'pid' => $request->pid,
            'start_date' => $request->start_date,
            'end_date' => $request->end_date,
            'status' => $request->status
        ]);

        return redirect()->route('admin.subscriptions.index')->with('success', __('subscription_updated'));
    }

    public function destroy($id)
    {
        Subscription::findOrFail($id)->delete();
        return redirect()->route('admin.subscriptions.index')->with('success', __('subscription_deleted'));
    }
}
