<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Shortener;

class ShortenerController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'admin']);
    }

    public function index()
    {
        $shorteners = Shortener::all();
        return view('admin.shorteners.index', compact('shorteners'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'provider' => 'required|in:bitly,tinyurl,isgd,custom'
        ]);

        Shortener::create([
            'name' => $request->name,
            'provider' => $request->provider,
            'api_key' => $request->api_key,
            'api_url' => $request->api_url,
            'status' => $request->has('status') ? 1 : 0
        ]);

        return redirect()->route('admin.shorteners.index')->with('success', __('shortener_created'));
    }

    public function update(Request $request, $id)
    {
        $shortener = Shortener::findOrFail($id);

        $shortener->update([
            'name' => $request->name,
            'provider' => $request->provider,
            'api_key' => $request->api_key,
            'api_url' => $request->api_url,
            'status' => $request->has('status') ? 1 : 0
        ]);

        return redirect()->route('admin.shorteners.index')->with('success', __('shortener_updated'));
    }

    public function destroy($id)
    {
        Shortener::findOrFail($id)->delete();
        return redirect()->route('admin.shorteners.index')->with('success', __('shortener_deleted'));
    }
}
