<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;
use App\Models\Language;
use App\Models\Package;

class SettingController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'admin']);
    }

    public function index()
    {
        $settings = Setting::pluck('value', 'key')->toArray();
        $languages = Language::all();
        $packages = Package::where('status', 1)->get();

        return view('admin.settings.index', compact('settings', 'languages', 'packages'));
    }

    public function general(Request $request)
    {
        $fields = ['site_name', 'site_url', 'contact_email', 'default_language', 
                   'default_timezone', 'currency'];

        foreach ($fields as $field) {
            if ($request->has($field)) {
                Setting::updateOrCreate(
                    ['key' => $field],
                    ['value' => $request->input($field)]
                );
            }
        }

        // Handle logo upload
        if ($request->hasFile('logo')) {
            $logo = $request->file('logo')->store('public/settings');
            Setting::updateOrCreate(['key' => 'logo'], ['value' => $logo]);
        }

        // Handle favicon upload
        if ($request->hasFile('favicon')) {
            $favicon = $request->file('favicon')->store('public/settings');
            Setting::updateOrCreate(['key' => 'favicon'], ['value' => $favicon]);
        }

        return redirect()->route('admin.settings.index')->with('success', __('settings_saved'));
    }

    public function system(Request $request)
    {
        $fields = ['registrations', 'email_verification', 'free_model', 'default_package'];

        foreach ($fields as $field) {
            Setting::updateOrCreate(
                ['key' => $field],
                ['value' => $request->input($field, 0)]
            );
        }

        return redirect()->route('admin.settings.index')->with('success', __('settings_saved'));
    }

    public function payment(Request $request)
    {
        $fields = ['paypal_enabled', 'paypal_mode', 'paypal_client_id', 'paypal_secret',
                   'stripe_enabled', 'stripe_public_key', 'stripe_secret_key'];

        foreach ($fields as $field) {
            if ($request->has($field)) {
                Setting::updateOrCreate(
                    ['key' => $field],
                    ['value' => $request->input($field)]
                );
            }
        }

        return redirect()->route('admin.settings.index')->with('success', __('settings_saved'));
    }

    public function theme(Request $request)
    {
        Setting::updateOrCreate(['key' => 'primary_color'], ['value' => $request->primary_color]);
        Setting::updateOrCreate(['key' => 'secondary_color'], ['value' => $request->secondary_color]);

        return redirect()->route('admin.settings.index')->with('success', __('settings_saved'));
    }
}
