<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Page;
use App\Models\Role;

class PageController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'admin']);
    }

    public function index()
    {
        $pages = Page::all();
        $roles = Role::all();
        return view('admin.pages.index', compact('pages', 'roles'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'slug' => 'required|string|unique:pages'
        ]);

        Page::create([
            'name' => $request->name,
            'slug' => $request->slug,
            'content' => $request->content,
            'roles' => is_array($request->roles) ? implode(',', $request->roles) : '1',
            'status' => $request->has('status') ? 1 : 0
        ]);

        return redirect()->route('admin.pages.index')->with('success', __('page_created'));
    }

    public function update(Request $request, $id)
    {
        $page = Page::findOrFail($id);

        $page->update([
            'name' => $request->name,
            'slug' => $request->slug,
            'content' => $request->content,
            'roles' => is_array($request->roles) ? implode(',', $request->roles) : '1',
            'status' => $request->has('status') ? 1 : 0
        ]);

        return redirect()->route('admin.pages.index')->with('success', __('page_updated'));
    }

    public function destroy($id)
    {
        Page::findOrFail($id)->delete();
        return redirect()->route('admin.pages.index')->with('success', __('page_deleted'));
    }
}
