<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Gateway;

class GatewayController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'admin']);
    }

    public function index()
    {
        $gateways = Gateway::all();
        $countries = config('countries', []);
        return view('admin.gateways.index', compact('gateways', 'countries'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'type' => 'required|in:sms,voice,mms'
        ]);

        Gateway::create([
            'name' => $request->name,
            'type' => $request->type,
            'api_url' => $request->api_url,
            'api_key' => $request->api_key,
            'api_secret' => $request->api_secret,
            'sender_id' => $request->sender_id,
            'status' => $request->has('status') ? 1 : 0
        ]);

        return redirect()->route('admin.gateways.index')->with('success', __('gateway_created'));
    }

    public function update(Request $request, $id)
    {
        $gateway = Gateway::findOrFail($id);

        $gateway->update([
            'name' => $request->name,
            'type' => $request->type,
            'api_url' => $request->api_url,
            'api_key' => $request->api_key,
            'api_secret' => $request->api_secret,
            'sender_id' => $request->sender_id,
            'status' => $request->has('status') ? 1 : 0
        ]);

        return redirect()->route('admin.gateways.index')->with('success', __('gateway_updated'));
    }

    public function destroy($id)
    {
        Gateway::findOrFail($id)->delete();
        return redirect()->route('admin.gateways.index')->with('success', __('gateway_deleted'));
    }

    public function rates(Request $request, $id)
    {
        $gateway = Gateway::findOrFail($id);

        $gateway->update([
            'default_rate' => $request->default_rate,
            'rates' => json_encode($request->rates ?? [])
        ]);

        return redirect()->route('admin.gateways.index')->with('success', __('rates_updated'));
    }
}
