# FlyWhats Laravel - دليل التثبيت والاستخدام

## نظرة عامة

تم تحويل نظام FlyWhats من PHP إلى Laravel 11 مع الحفاظ على التوافق الكامل مع WhatsApp Bridge القديم.

## هيكل المشروع

```
flywhats-laravel/
├── app/
│   ├── Http/
│   │   ├── Controllers/
│   │   │   ├── Admin/         # لوحة تحكم المدير
│   │   │   ├── Api/           # واجهات API
│   │   │   ├── Auth/          # المصادقة
│   │   │   ├── Dashboard/     # لوحة تحكم المستخدم
│   │   │   └── WhatsappWebhookController.php  # Webhooks للـ Bridge
│   ├── Models/                # 62 نموذج Eloquent
│   └── Services/
│       └── WhatsappBridgeService.php  # خدمة التواصل مع Bridge
├── config/
│   └── whatsapp.php           # إعدادات WhatsApp
├── database/
│   ├── migrations/            # 59 ملف migration
│   └── seeders/
│       └── LegacyDataSeeder.php  # استيراد البيانات القديمة
├── resources/views/           # 141 ملف Blade
└── routes/
    ├── api.php                # مسارات API
    └── web.php                # مسارات الويب
```

## متطلبات التثبيت

- PHP 8.2+
- MySQL 8.0+
- Composer 2.x
- Node.js 18+
- WhatsApp Bridge Go Application

## خطوات التثبيت

### 1. إعداد البيئة

```bash
cd flywhats-laravel
cp .env.example .env
```

قم بتعديل `.env`:
```env
APP_URL=http://your-domain.com
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=flywhats
DB_USERNAME=root
DB_PASSWORD=your_password

SYSTEM_TOKEN=your-secure-system-token
WHATSAPP_SITE_UNIQUE=your-site-unique
```

### 2. تثبيت الحزم

```bash
composer install
npm install && npm run build
```

### 3. إنشاء مفتاح التطبيق

```bash
php artisan key:generate
```

### 4. تشغيل Migrations

```bash
php artisan migrate
```

### 5. استيراد البيانات القديمة (اختياري)

لاستيراد البيانات من ملف SQL القديم:
```bash
php artisan db:seed --class=LegacyDataSeeder
```

أو لبيانات افتراضية جديدة:
```bash
php artisan db:seed
```

### 6. إعداد WhatsApp Bridge

تأكد من أن Bridge يرسل الطلبات إلى:
- `POST /whatsapp/received` - استقبال الرسائل
- `POST /whatsapp/status` - تحديث حالة الرسائل
- `GET /whatsapp/messages` - جلب الرسائل المعلقة
- `GET /whatsapp/link/success` - نجاح ربط الحساب

## API Endpoints

### WhatsApp API (v1)
- `POST /api/v1/whatsapp/send` - إرسال رسالة
- `POST /api/v1/whatsapp/send/bulk` - إرسال مجمّع
- `GET /api/v1/whatsapp/accounts` - قائمة الحسابات
- `GET /api/v1/whatsapp/groups` - قائمة المجموعات

### SMS API (v1)
- `POST /api/v1/sms/send` - إرسال SMS
- `GET /api/v1/sms/sent` - الرسائل المرسلة
- `GET /api/v1/sms/received` - الرسائل المستلمة

### Android Device API
- `GET /api/remote/messages` - جلب الرسائل للجهاز
- `POST /api/remote/status` - تحديث حالة الرسالة
- `POST /api/remote/received` - استقبال SMS

## WhatsApp Bridge Service

الخدمة `WhatsappBridgeService` تتوافق مع Bridge API v2.4.0:

```php
use App\Services\WhatsappBridgeService;

$wa = app(WhatsappBridgeService::class);

// إرسال رسالة
$result = $wa->sendPriority($secret, $url, $port, $unique, $id, $phone, $message);

// التحقق من حالة الحساب
$status = $wa->status($secret, $url, $port, $unique);

// جلب المجموعات
$groups = $wa->getGroups($server, $unique);
```

## الترخيص

جميع الحقوق محفوظة.
